<main id="main" class="main">
    <div class="pagetitle">
        <h1>Buat Postingan</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                <li class="breadcrumb-item active">Buat Postingan</li>
            </ol>
        </nav>
    </div>
    <!-- End Page Title -->
    <section class="section dashboard">
        <div class="card recent-sales overflow-auto">
            <div class="filter">
                <!-- Modal Dialog Scrollable -->
                <a href="#" class="icon" data-bs-toggle="modal" data-bs-target="#tambah_data">
                    <i class="bi bi-plus-lg"></i>
                </a>
            </div>
        </div>
        <div class="card mt-4">
            <div class="card-body">
                <h5 class="card-title">Tambah Postingan</h5>
                <form action="simpan_post.php" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="id">
                    <div class="mb-3">
                        <label for="title" class="form-label">Judul</label>
                        <input type="text" class="form-control" id="title" name="title" required>
                    </div>
                    <div class="mb-3">
                        <label for="slug" class="form-label">Slug</label>
                        <input type="text" class="form-control" id="slug" name="slug" required>
                    </div>
                    <div class="mb-3">
                        <label for="gambar" class="form-label">Gambar Header</label>
                        <input type="file" class="form-control" id="gambar" name="gambar">
                    </div>

                    <div class="mb-3">
                        <label for="content" class="form-label">Konten</label>
                        <textarea class="form-control" id="content" name="content"></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="status" class="form-label">Status</label>
                        <select class="form-control" id="status" name="status">
                            <option value="published">Published</option>
                            <option value="draft">Draft</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="published_at" class="form-label">Tanggal Publikasi</label>
                        <input type="datetime-local" class="form-control" id="published_at" name="published_at">
                    </div>
                    <input type="hidden" name="created_at">
                    <input type="hidden" name="updated_at">
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </form>
            </div>
        </div>
    </section>
</main>

<script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        CKEDITOR.replace('content', {
            removePlugins: 'notification'
        });
    });
</script>
<style>
    .cke_notification { display: none !important; }
</style>
<script>
    document.getElementById("title").addEventListener("input", function () {
        let title = this.value;
        let slug = title.toLowerCase()
            .replace(/[^\w\s-]/g, '')  // Hapus karakter selain huruf, angka, dan spasi
            .replace(/\s+/g, '-')      // Ganti spasi dengan "-"
            .replace(/--+/g, '-');     // Hapus duplikasi "-"
        document.getElementById("slug").value = slug;
    });
</script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        let now = new Date();
        let formattedDate = now.toISOString().slice(0, 16); // Format ke YYYY-MM-DDTHH:MM untuk input datetime-local
        document.getElementById("published_at").value = formattedDate;
    });
</script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        CKEDITOR.replace('content', {
            removePlugins: 'easyimage, cloudservices', // Nonaktifkan layanan cloud CKEditor
            extraPlugins: 'uploadimage,image2', // Pastikan plugin upload aktif
            filebrowserUploadUrl: 'upload.php', // Endpoint untuk upload gambar
            filebrowserUploadMethod: 'form', // Gunakan metode form untuk upload
            uploadUrl: 'upload.php', // URL untuk upload gambar secara langsung
            pasteFromClipboard: true, // Aktifkan paste gambar dari clipboard
            imageUploadUrl: 'upload.php', // Pastikan drag-and-drop diarahkan ke upload.php
            on: {
                instanceReady: function (ev) {
                    ev.editor.on('fileUploadRequest', function (evt) {
                        evt.data.requestData['csrf_token'] = 'YOUR_CSRF_TOKEN'; // Jika ada CSRF token
                    });
                }
            }
        });
    });
</script>


