<?php
require "koneksi.php"; // Pastikan koneksi database sudah di-include

// Pastikan ada parameter id di URL
if (!isset($_GET["id"]) || empty($_GET["id"])) {
    die("ID tidak valid.");
}

$id = $_GET["id"];

// Query untuk mengambil data postingan berdasarkan ID
$query =
    "SELECT id, title, slug, content, 'status', published_at, gambar FROM posts WHERE id = ?";
$stmt = mysqli_prepare($koneksi, $query);
mysqli_stmt_bind_param($stmt, "i", $id); // "i" untuk integer
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

// Cek apakah data ditemukan
if ($post = mysqli_fetch_assoc($result)) {
    // Data ditemukan, lanjut ke tampilan edit
} else {
    die("Postingan tidak ditemukan.");
}

mysqli_stmt_close($stmt);
mysqli_close($koneksi);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Postingan</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<main id="main" class="main">
    <div class="pagetitle">
        <h1>Edit Postingan</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                <li class="breadcrumb-item active">Edit Postingan</li>
            </ol>
        </nav>
    </div>

    <section class="section dashboard">
        <div class="card mt-4">
            <div class="card-body">
                <h5 class="card-title">Edit Postingan</h5>
                <form action="update_post.php" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="id" value="<?php echo htmlspecialchars(
                        $post["id"]
                    ); ?>">
                    <div class="mb-3">
                        <label for="title" class="form-label">Judul</label>
                        <input type="text" class="form-control" id="title" name="title" value="<?php echo htmlspecialchars(
                            $post["title"]
                        ); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="slug" class="form-label">Slug</label>
                        <input type="text" class="form-control" id="slug" name="slug" value="<?php echo htmlspecialchars(
                            $post["slug"]
                        ); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="gambar" class="form-label">Gambar Header</label>
                        <input type="file" class="form-control" id="gambar" name="gambar" onchange="previewImage(event)">

                        <!-- Preview Gambar -->
                        <div class="mt-3">
                            
                        <img id="preview" src="uploads/<?php echo htmlspecialchars($post['gambar']); ?>" alt="Preview Gambar" class="img-thumbnail" style="max-width: 300px;">

                        </div>
                    </div>

                    

                    <div class="mb-3">
                        <label for="content" class="form-label">Konten</label>
                        <textarea class="form-control" id="content" name="content"><?php echo htmlspecialchars(
                            $post["content"]
                        ); ?></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="status" class="form-label">Status</label>
                        <select class="form-control" id="status" name="status">
                            <option value="published" <?php echo $post[
                                "status"
                            ] === "published"
                                ? "selected"
                                : ""; ?>>Published</option>
                            <option value="draft" <?php echo $post["status"] ===
                            "draft"
                                ? "selected"
                                : ""; ?>>Draft</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="published_at" class="form-label">Tanggal Publikasi</label>
                        <input type="datetime-local" class="form-control" id="published_at" name="published_at" value="<?php echo date(
                            "Y-m-d\TH:i",
                            strtotime($post["published_at"])
                        ); ?>">
                    </div>
                    <button type="submit" class="btn btn-primary">Update</button>
                </form>
            </div>
        </div>
    </section>
</main>

<script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        CKEDITOR.replace('content', { removePlugins: 'notification' });
    });

    document.getElementById("title").addEventListener("input", function () {
        let title = this.value;
        let slug = title.toLowerCase()
            .replace(/[^\w\s-]/g, '')  
            .replace(/\s+/g, '-')      
            .replace(/--+/g, '-');     
        document.getElementById("slug").value = slug;
    });
</script>
</body>
</html>
