<?php
require "koneksi.php"; // Pastikan koneksi database sudah ada

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $id = $_POST["id"];

    // Ambil nama file gambar sebelum dihapus
    $query = "SELECT gambar FROM posts WHERE id = ?";
    $stmt = mysqli_prepare($koneksi, $query);
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    
    if ($post = mysqli_fetch_assoc($result)) {
        $gambar = $post["gambar"];

        // Hapus gambar jika ada
        if (!empty($gambar) && file_exists("uploads/" . $gambar)) {
            unlink("uploads/" . $gambar);
        }

        // Hapus data dari database
        $query = "DELETE FROM posts WHERE id = ?";
        $stmt = mysqli_prepare($koneksi, $query);
        mysqli_stmt_bind_param($stmt, "i", $id);
        
        if (mysqli_stmt_execute($stmt)) {
            mysqli_stmt_close($stmt);
            mysqli_close($koneksi);
            header("Location: index.php?page=voucher&notif=berhasil_hapus_data"); // Redirect setelah sukses
            exit();
        } else {
            die("Gagal menghapus data: " . mysqli_error($koneksi));
        }
    } else {
        die("Postingan tidak ditemukan.");
    }
} else {
    die("Akses tidak valid.");
}
