<main id="main" class="main">
    <div class="pagetitle">
        <h1>Atur Slider</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                <li class="breadcrumb-item">Atur Slider</li>
            </ol>
        </nav>
    </div>
    <!-- End Page Title -->
    <!-- Modal Tambah Data -->
    <!-- Modal Import XLS -->
    <!-- Tambahkan tombol untuk memanggil modal -->
    <div class="modal fade" id="tambah_data" tabindex="-1" aria-labelledby="tambahDataLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="tambahDataLabel">Tambah Game Baru</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="tambah_game.php" method="post" enctype="multipart/form-data">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="gambar" class="form-label">Gambar</label>
                            <input type="file" class="form-control" id="gambar" name="gambar" accept="image/*" required>
                        </div>
                        <div class="mb-3">
                            <label for="alt_text" class="form-label">Keterangan</label>
                            <textarea class="form-control" id="alt_text" name="alt_text" rows="3" required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <section class="section dashboard">
        <div class="card recent-sales overflow-auto">
            <div class="filter">
                <!-- Modal Dialog Scrollable -->
                <a href="#" class="icon" data-bs-toggle="modal" data-bs-target="#tambah_data">
                    <i class="bi bi-plus-lg"></i>
                </a>
            </div><br>
            <div class="card-body">
                <h5 class="card-title">Data Game</h5>
                <!-- Notifikasi -->
                <?php if (isset($_GET['notif'])): ?>
                    <div class="alert alert-success" role="alert">
                        <?php echo htmlspecialchars($_GET['notif']); ?>
                    </div>
                <?php endif; ?>
                <table class="table table-borderless datatable">
                    <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Gambar</th>
                            <th scope="col">Keterangan</th>
                            <th scope="col">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $no = 1;
                        $qry_games = mysqli_query($koneksi, "SELECT * FROM slider_banner ORDER BY id DESC");
                        while ($game = mysqli_fetch_array($qry_games)):
                            ?>
                            <tr>
                                <th><?php echo $no++; ?></th>
                                <td>
                                    <img src="<?php echo htmlspecialchars($game['gambar']); ?>"
                                        alt="<?php echo htmlspecialchars($game['alt_text']); ?>" style="max-width: 100px;">

                                </td>
                                <td><?php echo htmlspecialchars($game['alt_text']); ?></td>
                                <td>
                                    <!-- Modal Edit Game -->
                                    <div class="modal fade" id="editGameModal" tabindex="-1" aria-labelledby="editGameLabel"
                                        aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="editGameLabel">Edit Game</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tombol Hapus -->
                                    <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal"
                                        data-bs-target="#modalHapus_<?php echo htmlspecialchars($game['id']); ?>">
                                        <i class="bi bi-trash"></i>
                                    </button>

                                    <!-- Modal Konfirmasi Hapus -->
                                    <div class="modal fade" id="modalHapus_<?php echo htmlspecialchars($game['id']); ?>"
                                        tabindex="-1"
                                        aria-labelledby="hapusLabel_<?php echo htmlspecialchars($game['id']); ?>"
                                        aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title"
                                                        id="hapusLabel_<?php echo htmlspecialchars($game['id']); ?>">
                                                        Konfirmasi Hapus
                                                    </h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    Apakah Anda yakin ingin menghapus gambar ini?
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">Batal</button>
                                                    <form action="delete_slider.php" method="post">
                                                        <input type="hidden" name="id"
                                                            value="<?php echo htmlspecialchars($game['id']); ?>">
                                                        <button type="submit" class="btn btn-sm btn-danger">
                                                            <i class="bi bi-trash"></i> Hapus
                                                        </button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </section>
</main>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const editButtons = document.querySelectorAll(".edit-btn");
        editButtons.forEach(button => {
            button.addEventListener("click", function () {
                const id = this.getAttribute("data-id");
                const provider = this.getAttribute("data-provider");
                const gambar = this.getAttribute("data-gambar");
                const keterangan = this.getAttribute("data-keterangan");

                document.getElementById("edit_id").value = id;
                document.getElementById("edit_provider").value = provider;
                document.getElementById("edit_gambar_preview").src = gambar;
                document.getElementById("edit_keterangan").value = keterangan;
            });
        });
    });
</script>